package com.qboxus.tictic.adapters

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import com.qboxus.tictic.R
import com.qboxus.tictic.databinding.ItemFollowingBinding
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Functions.capitalizeEachWord
import com.qboxus.tictic.simpleclasses.Functions.frescoImageLoad

/**
 * Created by qboxus on 3/20/2018.
 */
class FollowingAdapter(
    var context: Context,
    var datalist: MutableList<UserModel>,
    var listener: OnItemClickListener
) : RecyclerView.Adapter<FollowingAdapter.CustomViewHolder>() {
    interface OnItemClickListener {
        fun onItemClick(view: View?, postion: Int, item: UserModel?)
    }

    override fun onCreateViewHolder(viewGroup: ViewGroup, viewtype: Int): CustomViewHolder {
        val binding: ItemFollowingBinding = DataBindingUtil.inflate(
            LayoutInflater.from(viewGroup.context),
            R.layout.item_following,
            viewGroup,
            false
        )

        return CustomViewHolder(binding)
    }

    override fun getItemCount(): Int {
        return datalist.size
    }

    inner class CustomViewHolder(val binding: ItemFollowingBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(pos: Int, item: UserModel?, listener: OnItemClickListener) {
            binding.mainlayout.setOnClickListener { v: View? -> listener.onItemClick(v, pos, item) }
            binding.actionTxt.setOnClickListener { v: View? -> listener.onItemClick(v, pos, item) }
        }
    }

    override fun onBindViewHolder(holder: CustomViewHolder, i: Int) {
        holder.setIsRecyclable(false)
        val item = datalist[i]

            holder.binding.userName.text = item.username
            holder.binding.userinfoTxt.text = item.first_name + " " + item.last_name


        holder.binding.userImage.controller = frescoImageLoad(
            item.getProfilePic(),
            R.drawable.ic_user_icon,
            holder.binding.userImage,
            false
        )


       holder.binding.actionTxt.text = capitalizeEachWord(item.button!!)
        if (item.button != null && (item.button.equals(
                "follow",
                ignoreCase = true
            ) || item.button.equals("follow back", ignoreCase = true))
        ) {
            holder.binding.actionTxt.background =
                ContextCompat.getDrawable(context, R.drawable.d_round_colord_6)
            holder.binding.actionTxt.setTextColor(ContextCompat.getColor(context, R.color.whiteColor))
        } else if (item.button != null &&
            (item.button.equals("following", ignoreCase = true) || item.button.equals(
                "friends",
                ignoreCase = true
            ))
        ) {
            holder.binding.actionTxt.background =
                ContextCompat.getDrawable(context, R.drawable.d_gray_border)
            holder.binding.actionTxt.setTextColor(ContextCompat.getColor(context, R.color.black))
        } else if (item.button != null && item.button.equals("0", ignoreCase = true)) {
            holder.binding.actionTxt.visibility = View.GONE
        }
        holder.bind(i, datalist[i], listener)
    }
}